NOTE "Determination of ?FLUID?_MudWt and the"
NOTE "composition of ?FLUID?_Decontaminated."

-- Copy 1 mass of Mud to a new Contamination mixture:

QIX Contamination 1 MASS Mud

-- Multiply the masses of the entire Contamination mixture by the
-- unknown weight fraction of mud for this sample:
 
MULTIPLY MASS of N2 to C30+ in Contamination by ?FLUID?_MudWt

-- Subtract the ?FLUID?_MudWt amount of the Contamination mixture
-- from one mass of the contaminated FEED stream and store it in
-- the ?FLUID?_Decontaminated mixture: 

QIX ?FLUID?_Decontaminated 1 MASS FEED -1 TANK Contamination

-- Fit the C8 through C29 amounts of the decontaminated mixture
-- to a Gamma function, using the global weighting factor of ?GammaWt?.
-- Regression will determine the ?FLUID?_MudWt variable giving the best fit.

GAMMA FIT ?FLUID?_Decontaminated C8 LOGAMTS
    IGNORE C30+
    WEIGHT AVERAGE 1
    WEIGHT ?GammaWt?

-- When reporting (if LaTeX is on), begin the two figures on a new page:

CLEARFIGURES

-- Rename, renormalize, and report (if LaTeX is on) the contaminated mixture:

LMIX ?FLUID?_Contaminated 1 MOLE FEED

-- Using the previously determined Gamma parameters, model and plot (if plotting is on)
-- the the C8 through C29 amounts of the contaminated mixture:

GAMMA MODEL ?FLUID?_Contaminated C8 LOGAMTS
    IGNORE C30+
    WEIGHT AVERAGE 1
    WEIGHT 0
    PLOT LOGMOLES

-- Rename, renormalize, and report (if LaTeX is on) the decontaminated mixture:

LMIX ?FLUID?_Decontaminated 1 MOLE ?FLUID?_Decontaminated

-- Using the previously determined Gamma parameters, model and plot (if plotting is on)
-- the the C8 through C29 amounts of the decontaminated mixture:

GAMMA MODEL ?FLUID?_Decontaminated C8 LOGAMTS
    IGNORE C30+
    WEIGHT AVERAGE 1
    WEIGHT 0
    PLOT LOGMOLES

-- Copy the decontaminated mixture to the FEED stream and perform a simple CCE
-- experiment to print out the mole and mass fractions of C1, C2-C5, and C6+.
-- These will be input later during the gravitational segregation step.

QIX FEED ?FLUID?_Decontaminated
TEMP 95 C
PRES 400 bar
CCE ID "Component groupings for ?FLUID?_Decontaminated"
STAGE     Z-C1   Z-C2-C5   Z-C6+   ZWT-C1   ZWT-C2-C5   ZWT-C6+
1
END
